/**
* \file: AlsaAudioIn.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPLay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_ALSAAUDIOIN_H
#define CARPLAY_ALSAAUDIOIN_H

#include <carplay_plugin.h>

namespace adit { namespace carplay
{

class AlsaAudioIn : public IAudioInAdapter
{

public:
    AlsaAudioIn();
    virtual ~AlsaAudioIn();

    // IAudioInAdapter implementation
    // no thread-safety required
public:
    virtual bool Initialize(const IConfiguration& inConfig, IAudioInSink& inSink);
    virtual bool Prepare(AudioFormatStruct inFormat, const std::string& inAudioType);
    virtual bool Start();
    virtual void Stop();

    // private section
private:
    class Impl;
    Impl* impl;
};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_ALSAAUDIOIN_H */
